%---------------------------------------
% RoE journal template
% Version 1.1 (20/02/20)
% CC BY-NC-SA
%
%---------------------------------------

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{RoE}[15/08/2021, v1.2]
\RequirePackage{ifthen}
\RequirePackage{calc}
\AtEndOfClass{\RequirePackage{microtype}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions*
\LoadClass{article}
\RequirePackage{ifpdf}      % Needed to pick between latex and pdflatex

%----------------------------------------------------------------------
%	NEEDED PACKAGES

\RequirePackage[utf8]{inputenc}
\RequirePackage{amsmath,amsfonts,amssymb}
\RequirePackage{graphicx,xcolor}
\RequirePackage{booktabs}
\RequirePackage{enumitem}


%----------------------------------------------------------------------
%	FONTS

\RequirePackage{times}      % Loads the Times-Roman Fonts
\RequirePackage{mathptmx}   % Loads the Times-Roman Math Fonts

%	COLUMNS
\setlength{\columnsep}{0.55cm} % Distance between the two columns of text
\setlength{\fboxrule}{0pt} % Width of the border around the abstract

%	COLORS
\definecolor{color1}{RGB}{0,0,90} % Color of the title and sections
\definecolor{color2}{RGB}{0,90,190} % Color of the boxes behind the abstract and type of paper

%	HYPERLINKS
\usepackage{hyperref} % Required for hyperlinks
\hypersetup{hidelinks,colorlinks,breaklinks=true,urlcolor=color2,citecolor=color1,linkcolor=color1,bookmarksopen=false,pdftitle={Title},pdfauthor={Author}}

%----------------------------------------------------------------------
%	MARGINS	
	  	  
\RequirePackage[left=1.75cm,%
right=1.75cm,%
top=1.5cm,%
bottom=2cm,%
headheight=11pt,%
letterpaper]{geometry}%
				
%----------------------------------------------------------------------
%	FIGURES AND TABLES CAPTIONS

\RequirePackage[labelfont={bf,sf,small},%
%labelsep=period,%
justification=raggedright]{caption}
%\setlength{\abovecaptionskip}{0pt}
%\setlength{\belowcaptionskip}{0pt}
				
%----------------------------------------------------------------------
%	PAGE HEADER

\RequirePackage{fancyhdr}  % Needed to define custom headers/footers
\RequirePackage{lastpage}  % Number of pages in the document
\pagestyle{fancy}          % Enables the custom headers/footers
% Headers
\lhead{\small\sffamily\bfseries\ RoE Journal}%
\chead{}%
\rhead{\small\sffamily\bfseries\@PaperTitle\  - \thepage/\pageref{LastPage}}
% Footers
%\lfoot{}%
%\cfoot{}%
%\rfoot{}%
\renewcommand{\headrulewidth}{0pt}% % No header rule
%\renewcommand{\footrulewidth}{0pt}% % No footer rule

%----------------------------------------------------------------------
%	SECTION/SUBSECTION/PARAGRAPH 

\RequirePackage[explicit]{titlesec}
\titleformat{\section}
  {\color{color1}\large\sffamily\bfseries}
  {\thesection.}
  {0.5em}
  %{\colorbox{color2!10}{\parbox{\dimexpr\linewidth-2\fboxsep\relax}{\centering\arabic{section}. #1}}}
  {#1}
  []
\titleformat{\subsection}
  {\color{color1}\sffamily\bfseries}
  {\thesubsection.}
  {0.5em}
  {#1}
  []
\titleformat{\subsubsection}
  {\sffamily\small\bfseries}
  {\thesubsubsection.}
  {0.5em}
  {#1}
  []    
\titleformat{\paragraph}[runin]
  {\sffamily\small\bfseries}
  {}
  {0em}
  {#1} 
\titlespacing*{\section}{0pc}{3ex \@plus4pt \@minus3pt}{5pt}
\titlespacing*{\subsection}{0pc}{2.5ex \@plus3pt \@minus2pt}{0pt}
\titlespacing*{\subsubsection}{0pc}{2ex \@plus2.5pt \@minus1.5pt}{0pt}
\titlespacing*{\paragraph}{0pc}{1.5ex \@plus2pt \@minus1pt}{10pt}


%----------------------------------------------------------------------
%	MULTIPLE AUTHOR
 
\newcount\@authcnt
\newcount\@tmpcnt\@tmpcnt\z@

\def\@affiliation{%
  \ifnum\@tmpcnt<\@authcnt
   \global\advance\@tmpcnt1
    \raggedright \csname @auth\romannumeral\the\@tmpcnt\endcsname\hfill\\%
   \let\next\@affiliation \vskip1pt
  \else
   \let\next\relax
  \fi
\next}
	 
\newcommand{\affiliation}[1]{%
    \global\advance\@authcnt1
    \expandafter\gdef\csname @auth\romannumeral\the\@authcnt\endcsname
    {#1}}


%----------------------------------------------------------------------
%	ABSTRACT+AUTHOR FRAME

\newcommand{\PaperType}[1]{\def\@PaperType{#1}}
\newcommand{\JournalTitle}[1]{\def\@JournalTitle{#1}}
\newcommand{\PaperTitle}[1]{\def\@PaperTitle{#1}}
\newcommand{\DOI}[1]{\def\@DOI{#1}}
\newcommand{\Authors}[1]{\def\@Authors{#1}}
\newcommand{\JournalInfo}[1]{\def\@JournalInfo{#1}}
\newcommand{\Abstract}[1]{\def\@Abstract{#1}}
\newcommand{\Keywords}[1]{\def\@Keywords{#1}}
\newcommand{\Dates}[1]{\def\@Dates{#1}}

% ---------------------------------------------------------------------
%    FRONT PAGE

\JournalTitle{Reviews of Electromagnetics}
\renewcommand{\@maketitle}{%
\twocolumn[{%
\thispagestyle{empty}%
\vskip-36pt%
{\raggedleft\small\sffamily\bfseries\@JournalTitle, \@JournalInfo\\\@PaperType\\\@DOI\par}%
\vskip20pt%
\fcolorbox{color1}{white}{%
	\parbox{\textwidth-2\fboxsep-20\fboxrule}{\centering%
		\colorbox{color2!20}{%
			\parbox{\textwidth-4\fboxsep-2\fboxrule}{%
				\sffamily\bfseries\fontsize{20}{25}\selectfont{} \color{color1!70}\centering{\@JournalTitle} \\ \color{color1}\centering{\@PaperType}%
			}%
		}%
	}
}
\vskip18pt%
{\raggedright\color{color1}\sffamily\bfseries\fontsize{25}{25}\selectfont \@PaperTitle\par}%
\vskip10pt%
{\raggedright\color{color1}\sffamily\fontsize{14}{16}\selectfont  \@Authors\par}%
\vskip18pt%
\fcolorbox{color1}{white}{%
	\parbox{\textwidth-2\fboxsep-2\fboxrule}{\centering%
		\colorbox{color2!5}{%
			\parbox{\textwidth-4\fboxsep-2\fboxrule}{%
				\ifx\@Keywords\@empty%
				\sffamily\textbf{\abstractname}\\\@Abstract%
				\else%
				\sffamily\textbf{\abstractname}\\\@Abstract\\[0pt]%
				\vskip0pt%
			\textbf{\keywordname}\\\@Keywords%
			\fi%
			}%
		}%
		\vskip8pt%
		\begingroup%
		\raggedright\sffamily\small%
		\small\@affiliation\par%
		\vskip4pt%
		\small\@Dates\par%
		\endgroup%%
	}%
}%
\vskip25pt%
}]%
}

%----------------------------------------------------------------------
%	REFERENCES
%----------------------------------------------------------------------  

% Remove brackets from numbering in List of References
\renewcommand{\@biblabel}[1]{\bfseries{[#1]}}
%\setlength{\bibitemsep}{0cm}
\let\oldbibliography\thebibliography
\renewcommand{\thebibliography}[1]{%
\addcontentsline{toc}{section}{\refname}%
\oldbibliography{#1}%
\setlength\itemsep{0pt}}%